/*
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
$(document).ready(function() {

    $(".click-title").mouseenter( function(    e){
        e.preventDefault();
        this.style.cursor="pointer";
    });
    $(".click-title").mousedown( function(event){
        event.preventDefault();
    });

    // Ugly code while this script is shared among several pages
    try{
        refreshHitsPerSecond(true);
    } catch(e){}
    try{
        refreshResponseTimeOverTime(true);
    } catch(e){}
    try{
        refreshResponseTimePercentiles();
    } catch(e){}
});


var responseTimePercentilesInfos = {
        data: {"result": {"minY": 3622.0, "minX": 0.0, "maxY": 20008.0, "series": [{"data": [[0.0, 3622.0], [0.1, 4520.0], [0.2, 4522.0], [0.3, 4522.0], [0.4, 5697.0], [0.5, 5828.0], [0.6, 5897.0], [0.7, 6048.0], [0.8, 6795.0], [0.9, 6852.0], [1.0, 7111.0], [1.1, 7282.0], [1.2, 7813.0], [1.3, 8097.0], [1.4, 8097.0], [1.5, 8311.0], [1.6, 8682.0], [1.7, 8698.0], [1.8, 9105.0], [1.9, 9339.0], [2.0, 9502.0], [2.1, 9597.0], [2.2, 10196.0], [2.3, 10685.0], [2.4, 10929.0], [2.5, 11599.0], [2.6, 11606.0], [2.7, 12096.0], [2.8, 12496.0], [2.9, 12595.0], [3.0, 12702.0], [3.1, 13107.0], [3.2, 13384.0], [3.3, 13597.0], [3.4, 13601.0], [3.5, 13813.0], [3.6, 13827.0], [3.7, 13884.0], [3.8, 13894.0], [3.9, 13996.0], [4.0, 14105.0], [4.1, 14192.0], [4.2, 14223.0], [4.3, 14280.0], [4.4, 14295.0], [4.5, 14299.0], [4.6, 14300.0], [4.7, 14396.0], [4.8, 14399.0], [4.9, 14400.0], [5.0, 14492.0], [5.1, 14501.0], [5.2, 14502.0], [5.3, 14507.0], [5.4, 14586.0], [5.5, 14593.0], [5.6, 14593.0], [5.7, 14594.0], [5.8, 14594.0], [5.9, 14597.0], [6.0, 14597.0], [6.1, 14602.0], [6.2, 14604.0], [6.3, 14610.0], [6.4, 14687.0], [6.5, 14689.0], [6.6, 14691.0], [6.7, 14693.0], [6.8, 14697.0], [6.9, 14701.0], [7.0, 14702.0], [7.1, 14707.0], [7.2, 14721.0], [7.3, 14746.0], [7.4, 14786.0], [7.5, 14786.0], [7.6, 14786.0], [7.7, 14790.0], [7.8, 14790.0], [7.9, 14796.0], [8.0, 14797.0], [8.1, 14797.0], [8.2, 14798.0], [8.3, 14799.0], [8.4, 14800.0], [8.5, 14800.0], [8.6, 14805.0], [8.7, 14806.0], [8.8, 14850.0], [8.9, 14868.0], [9.0, 14868.0], [9.1, 14881.0], [9.2, 14885.0], [9.3, 14890.0], [9.4, 14894.0], [9.5, 14894.0], [9.6, 14895.0], [9.7, 14895.0], [9.8, 14896.0], [9.9, 14897.0], [10.0, 14899.0], [10.1, 14899.0], [10.2, 14899.0], [10.3, 14900.0], [10.4, 14900.0], [10.5, 14902.0], [10.6, 14902.0], [10.7, 14902.0], [10.8, 14903.0], [10.9, 14904.0], [11.0, 14905.0], [11.1, 14907.0], [11.2, 14907.0], [11.3, 14938.0], [11.4, 14977.0], [11.5, 14989.0], [11.6, 14990.0], [11.7, 14991.0], [11.8, 14991.0], [11.9, 14993.0], [12.0, 14994.0], [12.1, 14995.0], [12.2, 14995.0], [12.3, 14995.0], [12.4, 14996.0], [12.5, 14996.0], [12.6, 14997.0], [12.7, 14997.0], [12.8, 14997.0], [12.9, 14999.0], [13.0, 14999.0], [13.1, 15000.0], [13.2, 15002.0], [13.3, 15002.0], [13.4, 15004.0], [13.5, 15005.0], [13.6, 15006.0], [13.7, 15014.0], [13.8, 15016.0], [13.9, 15077.0], [14.0, 15081.0], [14.1, 15083.0], [14.2, 15087.0], [14.3, 15088.0], [14.4, 15090.0], [14.5, 15090.0], [14.6, 15091.0], [14.7, 15091.0], [14.8, 15092.0], [14.9, 15094.0], [15.0, 15096.0], [15.1, 15096.0], [15.2, 15097.0], [15.3, 15097.0], [15.4, 15097.0], [15.5, 15097.0], [15.6, 15098.0], [15.7, 15098.0], [15.8, 15098.0], [15.9, 15099.0], [16.0, 15099.0], [16.1, 15100.0], [16.2, 15100.0], [16.3, 15101.0], [16.4, 15102.0], [16.5, 15103.0], [16.6, 15108.0], [16.7, 15108.0], [16.8, 15110.0], [16.9, 15153.0], [17.0, 15186.0], [17.1, 15187.0], [17.2, 15188.0], [17.3, 15189.0], [17.4, 15191.0], [17.5, 15191.0], [17.6, 15191.0], [17.7, 15194.0], [17.8, 15195.0], [17.9, 15196.0], [18.0, 15196.0], [18.1, 15196.0], [18.2, 15196.0], [18.3, 15197.0], [18.4, 15197.0], [18.5, 15198.0], [18.6, 15198.0], [18.7, 15199.0], [18.8, 15199.0], [18.9, 15200.0], [19.0, 15200.0], [19.1, 15200.0], [19.2, 15202.0], [19.3, 15202.0], [19.4, 15202.0], [19.5, 15203.0], [19.6, 15204.0], [19.7, 15204.0], [19.8, 15204.0], [19.9, 15209.0], [20.0, 15210.0], [20.1, 15212.0], [20.2, 15213.0], [20.3, 15215.0], [20.4, 15216.0], [20.5, 15228.0], [20.6, 15231.0], [20.7, 15231.0], [20.8, 15288.0], [20.9, 15289.0], [21.0, 15292.0], [21.1, 15293.0], [21.2, 15294.0], [21.3, 15294.0], [21.4, 15295.0], [21.5, 15295.0], [21.6, 15295.0], [21.7, 15295.0], [21.8, 15296.0], [21.9, 15297.0], [22.0, 15297.0], [22.1, 15298.0], [22.2, 15299.0], [22.3, 15299.0], [22.4, 15299.0], [22.5, 15299.0], [22.6, 15301.0], [22.7, 15301.0], [22.8, 15301.0], [22.9, 15302.0], [23.0, 15302.0], [23.1, 15302.0], [23.2, 15303.0], [23.3, 15303.0], [23.4, 15304.0], [23.5, 15305.0], [23.6, 15307.0], [23.7, 15307.0], [23.8, 15307.0], [23.9, 15309.0], [24.0, 15311.0], [24.1, 15329.0], [24.2, 15339.0], [24.3, 15357.0], [24.4, 15370.0], [24.5, 15380.0], [24.6, 15384.0], [24.7, 15389.0], [24.8, 15390.0], [24.9, 15392.0], [25.0, 15393.0], [25.1, 15393.0], [25.2, 15394.0], [25.3, 15394.0], [25.4, 15394.0], [25.5, 15395.0], [25.6, 15395.0], [25.7, 15395.0], [25.8, 15396.0], [25.9, 15397.0], [26.0, 15398.0], [26.1, 15398.0], [26.2, 15399.0], [26.3, 15399.0], [26.4, 15399.0], [26.5, 15399.0], [26.6, 15399.0], [26.7, 15399.0], [26.8, 15399.0], [26.9, 15400.0], [27.0, 15400.0], [27.1, 15400.0], [27.2, 15400.0], [27.3, 15401.0], [27.4, 15401.0], [27.5, 15402.0], [27.6, 15402.0], [27.7, 15405.0], [27.8, 15405.0], [27.9, 15408.0], [28.0, 15409.0], [28.1, 15409.0], [28.2, 15410.0], [28.3, 15413.0], [28.4, 15421.0], [28.5, 15436.0], [28.6, 15437.0], [28.7, 15454.0], [28.8, 15473.0], [28.9, 15479.0], [29.0, 15481.0], [29.1, 15481.0], [29.2, 15482.0], [29.3, 15482.0], [29.4, 15485.0], [29.5, 15487.0], [29.6, 15489.0], [29.7, 15491.0], [29.8, 15493.0], [29.9, 15493.0], [30.0, 15493.0], [30.1, 15494.0], [30.2, 15495.0], [30.3, 15495.0], [30.4, 15495.0], [30.5, 15496.0], [30.6, 15496.0], [30.7, 15496.0], [30.8, 15496.0], [30.9, 15496.0], [31.0, 15497.0], [31.1, 15497.0], [31.2, 15498.0], [31.3, 15498.0], [31.4, 15498.0], [31.5, 15498.0], [31.6, 15498.0], [31.7, 15499.0], [31.8, 15499.0], [31.9, 15499.0], [32.0, 15500.0], [32.1, 15500.0], [32.2, 15500.0], [32.3, 15501.0], [32.4, 15502.0], [32.5, 15502.0], [32.6, 15503.0], [32.7, 15503.0], [32.8, 15504.0], [32.9, 15504.0], [33.0, 15504.0], [33.1, 15505.0], [33.2, 15505.0], [33.3, 15505.0], [33.4, 15507.0], [33.5, 15507.0], [33.6, 15507.0], [33.7, 15508.0], [33.8, 15510.0], [33.9, 15511.0], [34.0, 15512.0], [34.1, 15512.0], [34.2, 15512.0], [34.3, 15512.0], [34.4, 15514.0], [34.5, 15535.0], [34.6, 15578.0], [34.7, 15589.0], [34.8, 15591.0], [34.9, 15593.0], [35.0, 15593.0], [35.1, 15593.0], [35.2, 15594.0], [35.3, 15594.0], [35.4, 15595.0], [35.5, 15595.0], [35.6, 15595.0], [35.7, 15595.0], [35.8, 15596.0], [35.9, 15596.0], [36.0, 15596.0], [36.1, 15596.0], [36.2, 15596.0], [36.3, 15597.0], [36.4, 15598.0], [36.5, 15598.0], [36.6, 15598.0], [36.7, 15598.0], [36.8, 15598.0], [36.9, 15599.0], [37.0, 15599.0], [37.1, 15599.0], [37.2, 15599.0], [37.3, 15600.0], [37.4, 15600.0], [37.5, 15600.0], [37.6, 15601.0], [37.7, 15602.0], [37.8, 15603.0], [37.9, 15603.0], [38.0, 15604.0], [38.1, 15604.0], [38.2, 15604.0], [38.3, 15604.0], [38.4, 15605.0], [38.5, 15605.0], [38.6, 15606.0], [38.7, 15607.0], [38.8, 15607.0], [38.9, 15608.0], [39.0, 15609.0], [39.1, 15610.0], [39.2, 15615.0], [39.3, 15620.0], [39.4, 15645.0], [39.5, 15655.0], [39.6, 15679.0], [39.7, 15683.0], [39.8, 15687.0], [39.9, 15690.0], [40.0, 15690.0], [40.1, 15691.0], [40.2, 15691.0], [40.3, 15692.0], [40.4, 15692.0], [40.5, 15693.0], [40.6, 15693.0], [40.7, 15694.0], [40.8, 15694.0], [40.9, 15694.0], [41.0, 15694.0], [41.1, 15695.0], [41.2, 15695.0], [41.3, 15695.0], [41.4, 15696.0], [41.5, 15697.0], [41.6, 15697.0], [41.7, 15698.0], [41.8, 15698.0], [41.9, 15698.0], [42.0, 15698.0], [42.1, 15699.0], [42.2, 15699.0], [42.3, 15700.0], [42.4, 15700.0], [42.5, 15700.0], [42.6, 15700.0], [42.7, 15701.0], [42.8, 15702.0], [42.9, 15702.0], [43.0, 15702.0], [43.1, 15702.0], [43.2, 15703.0], [43.3, 15703.0], [43.4, 15703.0], [43.5, 15703.0], [43.6, 15703.0], [43.7, 15703.0], [43.8, 15704.0], [43.9, 15705.0], [44.0, 15706.0], [44.1, 15707.0], [44.2, 15709.0], [44.3, 15709.0], [44.4, 15710.0], [44.5, 15711.0], [44.6, 15772.0], [44.7, 15783.0], [44.8, 15784.0], [44.9, 15784.0], [45.0, 15786.0], [45.1, 15787.0], [45.2, 15789.0], [45.3, 15790.0], [45.4, 15790.0], [45.5, 15791.0], [45.6, 15792.0], [45.7, 15792.0], [45.8, 15793.0], [45.9, 15793.0], [46.0, 15794.0], [46.1, 15794.0], [46.2, 15794.0], [46.3, 15795.0], [46.4, 15795.0], [46.5, 15796.0], [46.6, 15796.0], [46.7, 15797.0], [46.8, 15798.0], [46.9, 15798.0], [47.0, 15799.0], [47.1, 15799.0], [47.2, 15799.0], [47.3, 15800.0], [47.4, 15800.0], [47.5, 15802.0], [47.6, 15802.0], [47.7, 15802.0], [47.8, 15803.0], [47.9, 15803.0], [48.0, 15803.0], [48.1, 15803.0], [48.2, 15803.0], [48.3, 15805.0], [48.4, 15806.0], [48.5, 15807.0], [48.6, 15807.0], [48.7, 15807.0], [48.8, 15807.0], [48.9, 15809.0], [49.0, 15809.0], [49.1, 15831.0], [49.2, 15849.0], [49.3, 15872.0], [49.4, 15884.0], [49.5, 15887.0], [49.6, 15888.0], [49.7, 15888.0], [49.8, 15889.0], [49.9, 15889.0], [50.0, 15890.0], [50.1, 15890.0], [50.2, 15891.0], [50.3, 15892.0], [50.4, 15895.0], [50.5, 15895.0], [50.6, 15896.0], [50.7, 15897.0], [50.8, 15897.0], [50.9, 15897.0], [51.0, 15898.0], [51.1, 15898.0], [51.2, 15898.0], [51.3, 15899.0], [51.4, 15899.0], [51.5, 15899.0], [51.6, 15899.0], [51.7, 15899.0], [51.8, 15899.0], [51.9, 15900.0], [52.0, 15900.0], [52.1, 15901.0], [52.2, 15901.0], [52.3, 15902.0], [52.4, 15902.0], [52.5, 15902.0], [52.6, 15903.0], [52.7, 15903.0], [52.8, 15904.0], [52.9, 15904.0], [53.0, 15904.0], [53.1, 15904.0], [53.2, 15906.0], [53.3, 15907.0], [53.4, 15911.0], [53.5, 15912.0], [53.6, 15912.0], [53.7, 15913.0], [53.8, 15918.0], [53.9, 15926.0], [54.0, 15960.0], [54.1, 15982.0], [54.2, 15985.0], [54.3, 15987.0], [54.4, 15988.0], [54.5, 15989.0], [54.6, 15993.0], [54.7, 15995.0], [54.8, 15996.0], [54.9, 15997.0], [55.0, 15997.0], [55.1, 15997.0], [55.2, 15998.0], [55.3, 15998.0], [55.4, 15999.0], [55.5, 15999.0], [55.6, 15999.0], [55.7, 16000.0], [55.8, 16001.0], [55.9, 16001.0], [56.0, 16001.0], [56.1, 16002.0], [56.2, 16003.0], [56.3, 16005.0], [56.4, 16005.0], [56.5, 16006.0], [56.6, 16006.0], [56.7, 16008.0], [56.8, 16009.0], [56.9, 16011.0], [57.0, 16012.0], [57.1, 16013.0], [57.2, 16018.0], [57.3, 16052.0], [57.4, 16077.0], [57.5, 16083.0], [57.6, 16083.0], [57.7, 16088.0], [57.8, 16090.0], [57.9, 16090.0], [58.0, 16090.0], [58.1, 16092.0], [58.2, 16093.0], [58.3, 16093.0], [58.4, 16094.0], [58.5, 16095.0], [58.6, 16095.0], [58.7, 16096.0], [58.8, 16096.0], [58.9, 16096.0], [59.0, 16096.0], [59.1, 16097.0], [59.2, 16097.0], [59.3, 16097.0], [59.4, 16097.0], [59.5, 16098.0], [59.6, 16099.0], [59.7, 16099.0], [59.8, 16100.0], [59.9, 16100.0], [60.0, 16100.0], [60.1, 16100.0], [60.2, 16100.0], [60.3, 16100.0], [60.4, 16100.0], [60.5, 16102.0], [60.6, 16102.0], [60.7, 16102.0], [60.8, 16103.0], [60.9, 16103.0], [61.0, 16103.0], [61.1, 16104.0], [61.2, 16104.0], [61.3, 16104.0], [61.4, 16104.0], [61.5, 16104.0], [61.6, 16104.0], [61.7, 16105.0], [61.8, 16106.0], [61.9, 16108.0], [62.0, 16108.0], [62.1, 16109.0], [62.2, 16116.0], [62.3, 16146.0], [62.4, 16164.0], [62.5, 16182.0], [62.6, 16186.0], [62.7, 16190.0], [62.8, 16191.0], [62.9, 16191.0], [63.0, 16192.0], [63.1, 16193.0], [63.2, 16193.0], [63.3, 16194.0], [63.4, 16195.0], [63.5, 16196.0], [63.6, 16196.0], [63.7, 16196.0], [63.8, 16196.0], [63.9, 16196.0], [64.0, 16197.0], [64.1, 16197.0], [64.2, 16198.0], [64.3, 16198.0], [64.4, 16199.0], [64.5, 16200.0], [64.6, 16200.0], [64.7, 16200.0], [64.8, 16200.0], [64.9, 16200.0], [65.0, 16200.0], [65.1, 16200.0], [65.2, 16201.0], [65.3, 16201.0], [65.4, 16202.0], [65.5, 16202.0], [65.6, 16202.0], [65.7, 16202.0], [65.8, 16203.0], [65.9, 16203.0], [66.0, 16204.0], [66.1, 16205.0], [66.2, 16205.0], [66.3, 16205.0], [66.4, 16205.0], [66.5, 16206.0], [66.6, 16206.0], [66.7, 16207.0], [66.8, 16207.0], [66.9, 16215.0], [67.0, 16222.0], [67.1, 16244.0], [67.2, 16252.0], [67.3, 16266.0], [67.4, 16287.0], [67.5, 16288.0], [67.6, 16289.0], [67.7, 16291.0], [67.8, 16291.0], [67.9, 16291.0], [68.0, 16291.0], [68.1, 16292.0], [68.2, 16292.0], [68.3, 16293.0], [68.4, 16293.0], [68.5, 16293.0], [68.6, 16294.0], [68.7, 16294.0], [68.8, 16295.0], [68.9, 16296.0], [69.0, 16296.0], [69.1, 16297.0], [69.2, 16297.0], [69.3, 16297.0], [69.4, 16297.0], [69.5, 16297.0], [69.6, 16297.0], [69.7, 16298.0], [69.8, 16298.0], [69.9, 16299.0], [70.0, 16299.0], [70.1, 16299.0], [70.2, 16300.0], [70.3, 16300.0], [70.4, 16300.0], [70.5, 16300.0], [70.6, 16300.0], [70.7, 16300.0], [70.8, 16300.0], [70.9, 16302.0], [71.0, 16302.0], [71.1, 16302.0], [71.2, 16304.0], [71.3, 16304.0], [71.4, 16305.0], [71.5, 16306.0], [71.6, 16306.0], [71.7, 16315.0], [71.8, 16315.0], [71.9, 16358.0], [72.0, 16370.0], [72.1, 16382.0], [72.2, 16387.0], [72.3, 16389.0], [72.4, 16395.0], [72.5, 16395.0], [72.6, 16395.0], [72.7, 16396.0], [72.8, 16396.0], [72.9, 16396.0], [73.0, 16396.0], [73.1, 16396.0], [73.2, 16397.0], [73.3, 16397.0], [73.4, 16397.0], [73.5, 16397.0], [73.6, 16399.0], [73.7, 16399.0], [73.8, 16400.0], [73.9, 16401.0], [74.0, 16401.0], [74.1, 16401.0], [74.2, 16402.0], [74.3, 16402.0], [74.4, 16403.0], [74.5, 16405.0], [74.6, 16405.0], [74.7, 16405.0], [74.8, 16406.0], [74.9, 16412.0], [75.0, 16416.0], [75.1, 16417.0], [75.2, 16420.0], [75.3, 16441.0], [75.4, 16445.0], [75.5, 16471.0], [75.6, 16474.0], [75.7, 16482.0], [75.8, 16485.0], [75.9, 16488.0], [76.0, 16488.0], [76.1, 16491.0], [76.2, 16491.0], [76.3, 16495.0], [76.4, 16496.0], [76.5, 16496.0], [76.6, 16497.0], [76.7, 16498.0], [76.8, 16498.0], [76.9, 16498.0], [77.0, 16500.0], [77.1, 16500.0], [77.2, 16500.0], [77.3, 16500.0], [77.4, 16500.0], [77.5, 16501.0], [77.6, 16503.0], [77.7, 16503.0], [77.8, 16503.0], [77.9, 16504.0], [78.0, 16504.0], [78.1, 16504.0], [78.2, 16586.0], [78.3, 16590.0], [78.4, 16592.0], [78.5, 16592.0], [78.6, 16594.0], [78.7, 16595.0], [78.8, 16595.0], [78.9, 16596.0], [79.0, 16597.0], [79.1, 16597.0], [79.2, 16597.0], [79.3, 16598.0], [79.4, 16598.0], [79.5, 16599.0], [79.6, 16601.0], [79.7, 16602.0], [79.8, 16603.0], [79.9, 16603.0], [80.0, 16603.0], [80.1, 16603.0], [80.2, 16604.0], [80.3, 16607.0], [80.4, 16608.0], [80.5, 16609.0], [80.6, 16629.0], [80.7, 16651.0], [80.8, 16661.0], [80.9, 16687.0], [81.0, 16689.0], [81.1, 16692.0], [81.2, 16694.0], [81.3, 16696.0], [81.4, 16696.0], [81.5, 16697.0], [81.6, 16697.0], [81.7, 16698.0], [81.8, 16700.0], [81.9, 16700.0], [82.0, 16702.0], [82.1, 16702.0], [82.2, 16702.0], [82.3, 16703.0], [82.4, 16704.0], [82.5, 16704.0], [82.6, 16704.0], [82.7, 16705.0], [82.8, 16705.0], [82.9, 16706.0], [83.0, 16707.0], [83.1, 16707.0], [83.2, 16710.0], [83.3, 16719.0], [83.4, 16734.0], [83.5, 16749.0], [83.6, 16788.0], [83.7, 16791.0], [83.8, 16792.0], [83.9, 16792.0], [84.0, 16794.0], [84.1, 16796.0], [84.2, 16798.0], [84.3, 16800.0], [84.4, 16801.0], [84.5, 16802.0], [84.6, 16802.0], [84.7, 16806.0], [84.8, 16836.0], [84.9, 16892.0], [85.0, 16896.0], [85.1, 16898.0], [85.2, 16898.0], [85.3, 16898.0], [85.4, 16899.0], [85.5, 16899.0], [85.6, 16900.0], [85.7, 16900.0], [85.8, 16901.0], [85.9, 16901.0], [86.0, 16901.0], [86.1, 16902.0], [86.2, 16902.0], [86.3, 16902.0], [86.4, 16907.0], [86.5, 16912.0], [86.6, 16915.0], [86.7, 16919.0], [86.8, 16921.0], [86.9, 16991.0], [87.0, 16991.0], [87.1, 16992.0], [87.2, 16992.0], [87.3, 16992.0], [87.4, 16994.0], [87.5, 16995.0], [87.6, 16996.0], [87.7, 16997.0], [87.8, 16997.0], [87.9, 16998.0], [88.0, 16998.0], [88.1, 16999.0], [88.2, 16999.0], [88.3, 16999.0], [88.4, 16999.0], [88.5, 17000.0], [88.6, 17001.0], [88.7, 17001.0], [88.8, 17002.0], [88.9, 17002.0], [89.0, 17003.0], [89.1, 17004.0], [89.2, 17005.0], [89.3, 17008.0], [89.4, 17034.0], [89.5, 17080.0], [89.6, 17092.0], [89.7, 17092.0], [89.8, 17092.0], [89.9, 17092.0], [90.0, 17092.0], [90.1, 17095.0], [90.2, 17097.0], [90.3, 17097.0], [90.4, 17097.0], [90.5, 17097.0], [90.6, 17098.0], [90.7, 17098.0], [90.8, 17099.0], [90.9, 17099.0], [91.0, 17100.0], [91.1, 17100.0], [91.2, 17100.0], [91.3, 17100.0], [91.4, 17100.0], [91.5, 17100.0], [91.6, 17102.0], [91.7, 17102.0], [91.8, 17104.0], [91.9, 17128.0], [92.0, 17137.0], [92.1, 17178.0], [92.2, 17184.0], [92.3, 17194.0], [92.4, 17195.0], [92.5, 17196.0], [92.6, 17198.0], [92.7, 17200.0], [92.8, 17203.0], [92.9, 17211.0], [93.0, 17293.0], [93.1, 17296.0], [93.2, 17302.0], [93.3, 17303.0], [93.4, 17306.0], [93.5, 17307.0], [93.6, 17311.0], [93.7, 17316.0], [93.8, 17382.0], [93.9, 17388.0], [94.0, 17393.0], [94.1, 17396.0], [94.2, 17399.0], [94.3, 17400.0], [94.4, 17401.0], [94.5, 17402.0], [94.6, 17402.0], [94.7, 17408.0], [94.8, 17411.0], [94.9, 17422.0], [95.0, 17492.0], [95.1, 17498.0], [95.2, 17498.0], [95.3, 17498.0], [95.4, 17499.0], [95.5, 17500.0], [95.6, 17585.0], [95.7, 17594.0], [95.8, 17595.0], [95.9, 17598.0], [96.0, 17599.0], [96.1, 17606.0], [96.2, 17699.0], [96.3, 17701.0], [96.4, 17766.0], [96.5, 17793.0], [96.6, 17798.0], [96.7, 17799.0], [96.8, 17800.0], [96.9, 17801.0], [97.0, 17802.0], [97.1, 17813.0], [97.2, 17813.0], [97.3, 17895.0], [97.4, 17908.0], [97.5, 17996.0], [97.6, 17997.0], [97.7, 17997.0], [97.8, 18009.0], [97.9, 18014.0], [98.0, 18092.0], [98.1, 18108.0], [98.2, 18117.0], [98.3, 18199.0], [98.4, 18201.0], [98.5, 18202.0], [98.6, 18208.0], [98.7, 18303.0], [98.8, 18314.0], [98.9, 18397.0], [99.0, 18407.0], [99.1, 18412.0], [99.2, 18503.0], [99.3, 18605.0], [99.4, 18708.0], [99.5, 18796.0], [99.6, 18910.0], [99.7, 19203.0], [99.8, 19399.0], [99.9, 20008.0]], "isOverall": false, "label": "Insert Invoice", "isController": false}], "supportsControllersDiscrimination": true, "maxX": 100.0, "title": "Response Time Percentiles"}},
        getOptions: function() {
            return {
                series: {
                    points: { show: false }
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimePercentiles'
                },
                xaxis: {
                    tickDecimals: 1,
                    axisLabel: "Percentiles",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Percentile value in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : %x.2 percentile was %y ms"
                },
                selection: { mode: "xy" },
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimePercentiles"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimesPercentiles"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimesPercentiles"), dataset, prepareOverviewOptions(options));
        }
};

/**
 * @param elementId Id of element where we display message
 */
function setEmptyGraph(elementId) {
    $(function() {
        $(elementId).text("No graph series with filter="+seriesFilter);
    });
}

// Response times percentiles
function refreshResponseTimePercentiles() {
    var infos = responseTimePercentilesInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimePercentiles");
        return;
    }
    if (isGraph($("#flotResponseTimesPercentiles"))){
        infos.createGraph();
    } else {
        var choiceContainer = $("#choicesResponseTimePercentiles");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimesPercentiles", "#overviewResponseTimesPercentiles");
        $('#bodyResponseTimePercentiles .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var responseTimeDistributionInfos = {
        data: {"result": {"minY": 1.0, "minX": 3600.0, "maxY": 57.0, "series": [{"data": [[3600.0, 1.0], [4500.0, 2.0], [5500.0, 1.0], [5600.0, 1.0], [5800.0, 2.0], [6000.0, 1.0], [6800.0, 1.0], [6700.0, 1.0], [7100.0, 1.0], [7200.0, 1.0], [7800.0, 1.0], [8000.0, 1.0], [8600.0, 2.0], [8300.0, 1.0], [9100.0, 1.0], [9300.0, 1.0], [9500.0, 2.0], [10100.0, 1.0], [10600.0, 1.0], [10900.0, 1.0], [11600.0, 1.0], [11500.0, 1.0], [12000.0, 1.0], [12400.0, 1.0], [12500.0, 1.0], [12700.0, 1.0], [13300.0, 1.0], [13100.0, 1.0], [13800.0, 4.0], [13500.0, 1.0], [13600.0, 1.0], [13900.0, 1.0], [14200.0, 5.0], [14300.0, 3.0], [14100.0, 2.0], [14800.0, 19.0], [14700.0, 15.0], [14500.0, 10.0], [14600.0, 8.0], [14400.0, 2.0], [14900.0, 28.0], [15000.0, 30.0], [15300.0, 43.0], [15100.0, 28.0], [15200.0, 36.0], [15700.0, 50.0], [15600.0, 50.0], [15500.0, 53.0], [15800.0, 46.0], [15400.0, 51.0], [16200.0, 57.0], [16100.0, 47.0], [15900.0, 38.0], [16300.0, 36.0], [16000.0, 41.0], [16600.0, 23.0], [16500.0, 26.0], [17300.0, 11.0], [17200.0, 5.0], [16700.0, 25.0], [16400.0, 32.0], [17400.0, 12.0], [17100.0, 17.0], [17000.0, 25.0], [16900.0, 29.0], [16800.0, 13.0], [17600.0, 2.0], [17500.0, 6.0], [18300.0, 3.0], [18000.0, 3.0], [18100.0, 3.0], [18200.0, 3.0], [17700.0, 5.0], [17800.0, 6.0], [17900.0, 4.0], [18400.0, 2.0], [18500.0, 1.0], [18900.0, 1.0], [19300.0, 1.0], [18700.0, 2.0], [19200.0, 1.0], [18600.0, 1.0], [20000.0, 1.0]], "isOverall": false, "label": "Insert Invoice", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 100, "maxX": 20000.0, "title": "Response Time Distribution"}},
        getOptions: function() {
            var granularity = this.data.result.granularity;
            return {
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimeDistribution'
                },
                xaxis:{
                    axisLabel: "Response times in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of responses",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                bars : {
                    show: true,
                    barWidth: this.data.result.granularity
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: function(label, xval, yval, flotItem){
                        return yval + " responses for " + label + " were between " + xval + " and " + (xval + granularity) + " ms";
                    }
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimeDistribution"), prepareData(data.result.series, $("#choicesResponseTimeDistribution")), options);
        }

};

// Response time distribution
function refreshResponseTimeDistribution() {
    var infos = responseTimeDistributionInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimeDistribution");
        return;
    }
    if (isGraph($("#flotResponseTimeDistribution"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimeDistribution");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        $('#footerResponseTimeDistribution .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var syntheticResponseTimeDistributionInfos = {
        data: {"result": {"minY": 1000.0, "minX": 2.0, "ticks": [[0, "Requests having \nresponse time <= 500ms"], [1, "Requests having \nresponse time > 500ms and <= 1,500ms"], [2, "Requests having \nresponse time > 1,500ms"], [3, "Requests in error"]], "maxY": 1000.0, "series": [{"data": [], "color": "#9ACD32", "isOverall": false, "label": "Requests having \nresponse time <= 500ms", "isController": false}, {"data": [], "color": "yellow", "isOverall": false, "label": "Requests having \nresponse time > 500ms and <= 1,500ms", "isController": false}, {"data": [[2.0, 1000.0]], "color": "orange", "isOverall": false, "label": "Requests having \nresponse time > 1,500ms", "isController": false}, {"data": [], "color": "#FF6347", "isOverall": false, "label": "Requests in error", "isController": false}], "supportsControllersDiscrimination": false, "maxX": 2.0, "title": "Synthetic Response Times Distribution"}},
        getOptions: function() {
            return {
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendSyntheticResponseTimeDistribution'
                },
                xaxis:{
                    axisLabel: "Response times ranges",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                    tickLength:0,
                    min:-0.5,
                    max:3.5
                },
                yaxis: {
                    axisLabel: "Number of responses",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                bars : {
                    show: true,
                    align: "center",
                    barWidth: 0.25,
                    fill:.75
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: function(label, xval, yval, flotItem){
                        return yval + " " + label;
                    }
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var options = this.getOptions();
            prepareOptions(options, data);
            options.xaxis.ticks = data.result.ticks;
            $.plot($("#flotSyntheticResponseTimeDistribution"), prepareData(data.result.series, $("#choicesSyntheticResponseTimeDistribution")), options);
        }

};

// Response time distribution
function refreshSyntheticResponseTimeDistribution() {
    var infos = syntheticResponseTimeDistributionInfos;
    prepareSeries(infos.data, true);
    if (isGraph($("#flotSyntheticResponseTimeDistribution"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesSyntheticResponseTimeDistribution");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        $('#footerSyntheticResponseTimeDistribution .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var activeThreadsOverTimeInfos = {
        data: {"result": {"minY": 7.749999999999999, "minX": 1.72181274E12, "maxY": 10.0, "series": [{"data": [[1.72181304E12, 10.0], [1.72181274E12, 9.545454545454547], [1.7218134E12, 10.0], [1.7218131E12, 10.0], [1.72181328E12, 10.0], [1.72181298E12, 10.0], [1.72181334E12, 10.0], [1.72181352E12, 7.964285714285715], [1.72181322E12, 10.0], [1.72181292E12, 10.0], [1.7218128E12, 10.0], [1.72181346E12, 10.0], [1.72181316E12, 10.0], [1.72181286E12, 10.0]], "isOverall": false, "label": "172.18.0.5-Thread Group", "isController": false}, {"data": [[1.72181304E12, 10.0], [1.72181274E12, 9.458333333333332], [1.7218134E12, 10.0], [1.7218131E12, 10.0], [1.72181328E12, 10.0], [1.72181298E12, 10.0], [1.72181334E12, 10.0], [1.72181352E12, 7.749999999999999], [1.72181322E12, 10.0], [1.72181292E12, 10.0], [1.7218128E12, 10.0], [1.72181346E12, 10.0], [1.72181316E12, 10.0], [1.72181286E12, 10.0]], "isOverall": false, "label": "172.18.0.6-Thread Group", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.72181352E12, "title": "Active Threads Over Time"}},
        getOptions: function() {
            return {
                series: {
                    stack: true,
                    lines: {
                        show: true,
                        fill: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of active threads",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 6,
                    show: true,
                    container: '#legendActiveThreadsOverTime'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                selection: {
                    mode: 'xy'
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : At %x there were %y active threads"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesActiveThreadsOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotActiveThreadsOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewActiveThreadsOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Active Threads Over Time
function refreshActiveThreadsOverTime(fixTimestamps) {
    var infos = activeThreadsOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 7200000);
    }
    if(isGraph($("#flotActiveThreadsOverTime"))) {
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesActiveThreadsOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotActiveThreadsOverTime", "#overviewActiveThreadsOverTime");
        $('#footerActiveThreadsOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var timeVsThreadsInfos = {
        data: {"result": {"minY": 7955.0, "minX": 1.0, "maxY": 15897.431677018636, "series": [{"data": [[8.0, 11504.0], [4.0, 13403.5], [2.0, 8504.5], [1.0, 7955.0], [9.0, 13234.25], [5.0, 8939.0], [10.0, 15897.431677018636], [6.0, 13122.2], [3.0, 9650.5], [7.0, 15369.666666666666]], "isOverall": false, "label": "Insert Invoice", "isController": false}, {"data": [[9.856999999999996, 15759.490000000007]], "isOverall": false, "label": "Insert Invoice-Aggregated", "isController": false}], "supportsControllersDiscrimination": true, "maxX": 10.0, "title": "Time VS Threads"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    axisLabel: "Number of active threads",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response times in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: { noColumns: 2,show: true, container: '#legendTimeVsThreads' },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s: At %x.2 active threads, Average response time was %y.2 ms"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesTimeVsThreads"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotTimesVsThreads"), dataset, options);
            // setup overview
            $.plot($("#overviewTimesVsThreads"), dataset, prepareOverviewOptions(options));
        }
};

// Time vs threads
function refreshTimeVsThreads(){
    var infos = timeVsThreadsInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyTimeVsThreads");
        return;
    }
    if(isGraph($("#flotTimesVsThreads"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTimeVsThreads");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTimesVsThreads", "#overviewTimesVsThreads");
        $('#footerTimeVsThreads .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var bytesThroughputOverTimeInfos = {
        data : {"result": {"minY": 994.5333333333333, "minX": 1.72181274E12, "maxY": 5882.5, "series": [{"data": [[1.72181304E12, 1581.6666666666667], [1.72181274E12, 994.5333333333333], [1.7218134E12, 1690.0], [1.7218131E12, 1646.6666666666667], [1.72181328E12, 1603.3333333333333], [1.72181298E12, 1560.0], [1.72181334E12, 1603.3333333333333], [1.72181352E12, 1213.3333333333333], [1.72181322E12, 1625.0], [1.72181292E12, 1603.3], [1.7218128E12, 1665.7666666666667], [1.72181346E12, 1603.3333333333333], [1.72181316E12, 1625.0], [1.72181286E12, 1644.2]], "isOverall": false, "label": "Bytes received per second", "isController": false}, {"data": [[1.72181304E12, 5505.416666666667], [1.72181274E12, 3468.1], [1.7218134E12, 5882.5], [1.7218131E12, 5731.666666666667], [1.72181328E12, 5580.833333333333], [1.72181298E12, 5430.0], [1.72181334E12, 5580.833333333333], [1.72181352E12, 4223.333333333333], [1.72181322E12, 5656.25], [1.72181292E12, 5580.816666666667], [1.7218128E12, 5805.8], [1.72181346E12, 5580.833333333333], [1.72181316E12, 5656.25], [1.72181286E12, 5730.433333333333]], "isOverall": false, "label": "Bytes sent per second", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.72181352E12, "title": "Bytes Throughput Over Time"}},
        getOptions : function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity) ,
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Bytes / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendBytesThroughputOverTime'
                },
                selection: {
                    mode: "xy"
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y"
                }
            };
        },
        createGraph : function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesBytesThroughputOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotBytesThroughputOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewBytesThroughputOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Bytes throughput Over Time
function refreshBytesThroughputOverTime(fixTimestamps) {
    var infos = bytesThroughputOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 7200000);
    }
    if(isGraph($("#flotBytesThroughputOverTime"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesBytesThroughputOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotBytesThroughputOverTime", "#overviewBytesThroughputOverTime");
        $('#footerBytesThroughputOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var responseTimesOverTimeInfos = {
        data: {"result": {"minY": 11832.826086956524, "minX": 1.72181274E12, "maxY": 16596.87671232877, "series": [{"data": [[1.72181304E12, 16596.87671232877], [1.72181274E12, 11832.826086956524], [1.7218134E12, 15608.24358974359], [1.7218131E12, 15821.302631578948], [1.72181328E12, 16301.60810810811], [1.72181298E12, 16571.833333333332], [1.72181334E12, 16014.324324324323], [1.72181352E12, 14720.696428571426], [1.72181322E12, 15865.906666666671], [1.72181292E12, 16028.094594594595], [1.7218128E12, 15591.896103896106], [1.72181346E12, 16218.770270270272], [1.72181316E12, 16100.986666666662], [1.72181286E12, 15664.144736842105]], "isOverall": false, "label": "Insert Invoice", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.72181352E12, "title": "Response Time Over Time"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average response time was %y ms"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Response Times Over Time
function refreshResponseTimeOverTime(fixTimestamps) {
    var infos = responseTimesOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimeOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 7200000);
    }
    if(isGraph($("#flotResponseTimesOverTime"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimesOverTime", "#overviewResponseTimesOverTime");
        $('#footerResponseTimesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var latenciesOverTimeInfos = {
        data: {"result": {"minY": 11832.543478260868, "minX": 1.72181274E12, "maxY": 16596.780821917815, "series": [{"data": [[1.72181304E12, 16596.780821917815], [1.72181274E12, 11832.543478260868], [1.7218134E12, 15608.23076923077], [1.7218131E12, 15821.236842105263], [1.72181328E12, 16301.459459459462], [1.72181298E12, 16571.763888888883], [1.72181334E12, 16014.25675675676], [1.72181352E12, 14720.678571428569], [1.72181322E12, 15865.840000000004], [1.72181292E12, 16028.0], [1.7218128E12, 15591.753246753244], [1.72181346E12, 16218.729729729725], [1.72181316E12, 16100.90666666666], [1.72181286E12, 15664.052631578948]], "isOverall": false, "label": "Insert Invoice", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.72181352E12, "title": "Latencies Over Time"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response latencies in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendLatenciesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average latency was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesLatenciesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotLatenciesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewLatenciesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Latencies Over Time
function refreshLatenciesOverTime(fixTimestamps) {
    var infos = latenciesOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyLatenciesOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 7200000);
    }
    if(isGraph($("#flotLatenciesOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesLatenciesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotLatenciesOverTime", "#overviewLatenciesOverTime");
        $('#footerLatenciesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var connectTimeOverTimeInfos = {
        data: {"result": {"minY": 3.9305555555555545, "minX": 1.72181274E12, "maxY": 129.9565217391305, "series": [{"data": [[1.72181304E12, 5.109589041095889], [1.72181274E12, 129.9565217391305], [1.7218134E12, 6.551282051282052], [1.7218131E12, 7.7894736842105265], [1.72181328E12, 6.000000000000001], [1.72181298E12, 3.9305555555555545], [1.72181334E12, 5.648648648648645], [1.72181352E12, 6.196428571428572], [1.72181322E12, 6.440000000000005], [1.72181292E12, 5.445945945945946], [1.7218128E12, 10.818181818181817], [1.72181346E12, 5.810810810810811], [1.72181316E12, 8.040000000000003], [1.72181286E12, 9.947368421052632]], "isOverall": false, "label": "Insert Invoice", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.72181352E12, "title": "Connect Time Over Time"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getConnectTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average Connect Time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendConnectTimeOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average connect time was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesConnectTimeOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotConnectTimeOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewConnectTimeOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Connect Time Over Time
function refreshConnectTimeOverTime(fixTimestamps) {
    var infos = connectTimeOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyConnectTimeOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 7200000);
    }
    if(isGraph($("#flotConnectTimeOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesConnectTimeOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotConnectTimeOverTime", "#overviewConnectTimeOverTime");
        $('#footerConnectTimeOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var responseTimePercentilesOverTimeInfos = {
        data: {"result": {"minY": 3622.0, "minX": 1.72181274E12, "maxY": 20008.0, "series": [{"data": [[1.72181304E12, 18407.0], [1.72181274E12, 16315.0], [1.7218134E12, 17701.0], [1.7218131E12, 17098.0], [1.72181328E12, 17895.0], [1.72181298E12, 20008.0], [1.72181334E12, 17798.0], [1.72181352E12, 16902.0], [1.72181322E12, 17598.0], [1.72181292E12, 17311.0], [1.7218128E12, 17606.0], [1.72181346E12, 18605.0], [1.72181316E12, 17801.0], [1.72181286E12, 17595.0]], "isOverall": false, "label": "Max", "isController": false}, {"data": [[1.72181304E12, 17870.0], [1.72181274E12, 15991.9], [1.7218134E12, 16595.7], [1.7218131E12, 16366.7], [1.72181328E12, 17100.0], [1.72181298E12, 18471.2], [1.72181334E12, 16945.5], [1.72181352E12, 16496.5], [1.72181322E12, 16718.0], [1.72181292E12, 17045.0], [1.7218128E12, 16477.6], [1.72181346E12, 17495.0], [1.72181316E12, 17278.4], [1.72181286E12, 16631.6]], "isOverall": false, "label": "90th percentile", "isController": false}, {"data": [[1.72181304E12, 18407.0], [1.72181274E12, 16315.0], [1.7218134E12, 17701.0], [1.7218131E12, 17098.0], [1.72181328E12, 17895.0], [1.72181298E12, 20008.0], [1.72181334E12, 17798.0], [1.72181352E12, 16902.0], [1.72181322E12, 17598.0], [1.72181292E12, 17311.0], [1.7218128E12, 17606.0], [1.72181346E12, 18605.0], [1.72181316E12, 17801.0], [1.72181286E12, 17595.0]], "isOverall": false, "label": "99th percentile", "isController": false}, {"data": [[1.72181304E12, 18135.3], [1.72181274E12, 16195.0], [1.7218134E12, 16996.55], [1.7218131E12, 16644.699999999997], [1.72181328E12, 17247.0], [1.72181298E12, 19012.55], [1.72181334E12, 17318.75], [1.72181352E12, 16618.3], [1.72181322E12, 17163.0], [1.72181292E12, 17194.25], [1.7218128E12, 16706.1], [1.72181346E12, 18026.25], [1.72181316E12, 17595.0], [1.72181286E12, 16775.099999999995]], "isOverall": false, "label": "95th percentile", "isController": false}, {"data": [[1.72181304E12, 14881.0], [1.72181274E12, 3622.0], [1.7218134E12, 14399.0], [1.7218131E12, 14796.0], [1.72181328E12, 15004.0], [1.72181298E12, 12595.0], [1.72181334E12, 14790.0], [1.72181352E12, 7813.0], [1.72181322E12, 14899.0], [1.72181292E12, 14586.0], [1.7218128E12, 13597.0], [1.72181346E12, 14597.0], [1.72181316E12, 14501.0], [1.72181286E12, 13601.0]], "isOverall": false, "label": "Min", "isController": false}, {"data": [[1.72181304E12, 16687.0], [1.72181274E12, 13860.5], [1.7218134E12, 15504.5], [1.7218131E12, 15888.0], [1.72181328E12, 16294.5], [1.72181298E12, 16641.5], [1.72181334E12, 16097.5], [1.72181352E12, 15501.5], [1.72181322E12, 15786.0], [1.72181292E12, 16005.0], [1.7218128E12, 15508.0], [1.72181346E12, 16202.5], [1.72181316E12, 15999.0], [1.72181286E12, 15606.5]], "isOverall": false, "label": "Median", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.72181352E12, "title": "Response Time Percentiles Over Time (successful requests only)"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true,
                        fill: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Response Time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimePercentilesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Response time was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimePercentilesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimePercentilesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimePercentilesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Response Time Percentiles Over Time
function refreshResponseTimePercentilesOverTime(fixTimestamps) {
    var infos = responseTimePercentilesOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 7200000);
    }
    if(isGraph($("#flotResponseTimePercentilesOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesResponseTimePercentilesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimePercentilesOverTime", "#overviewResponseTimePercentilesOverTime");
        $('#footerResponseTimePercentilesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var responseTimeVsRequestInfos = {
    data: {"result": {"minY": 15803.0, "minX": 1.0, "maxY": 19203.0, "series": [{"data": [[2.0, 15859.0], [1.0, 15803.0], [4.0, 17810.0], [5.0, 19203.0], [3.0, 15902.5]], "isOverall": false, "label": "Successes", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 1000, "maxX": 5.0, "title": "Response Time Vs Request"}},
    getOptions: function() {
        return {
            series: {
                lines: {
                    show: false
                },
                points: {
                    show: true
                }
            },
            xaxis: {
                axisLabel: "Global number of requests per second",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            yaxis: {
                axisLabel: "Median Response Time in ms",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            legend: {
                noColumns: 2,
                show: true,
                container: '#legendResponseTimeVsRequest'
            },
            selection: {
                mode: 'xy'
            },
            grid: {
                hoverable: true // IMPORTANT! this is needed for tooltip to work
            },
            tooltip: true,
            tooltipOpts: {
                content: "%s : Median response time at %x req/s was %y ms"
            },
            colors: ["#9ACD32", "#FF6347"]
        };
    },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesResponseTimeVsRequest"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotResponseTimeVsRequest"), dataset, options);
        // setup overview
        $.plot($("#overviewResponseTimeVsRequest"), dataset, prepareOverviewOptions(options));

    }
};

// Response Time vs Request
function refreshResponseTimeVsRequest() {
    var infos = responseTimeVsRequestInfos;
    prepareSeries(infos.data);
    if (isGraph($("#flotResponseTimeVsRequest"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimeVsRequest");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimeVsRequest", "#overviewResponseTimeVsRequest");
        $('#footerResponseRimeVsRequest .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var latenciesVsRequestInfos = {
    data: {"result": {"minY": 15803.0, "minX": 1.0, "maxY": 19203.0, "series": [{"data": [[2.0, 15858.5], [1.0, 15803.0], [4.0, 17810.0], [5.0, 19203.0], [3.0, 15902.5]], "isOverall": false, "label": "Successes", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 1000, "maxX": 5.0, "title": "Latencies Vs Request"}},
    getOptions: function() {
        return{
            series: {
                lines: {
                    show: false
                },
                points: {
                    show: true
                }
            },
            xaxis: {
                axisLabel: "Global number of requests per second",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            yaxis: {
                axisLabel: "Median Latency in ms",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            legend: { noColumns: 2,show: true, container: '#legendLatencyVsRequest' },
            selection: {
                mode: 'xy'
            },
            grid: {
                hoverable: true // IMPORTANT! this is needed for tooltip to work
            },
            tooltip: true,
            tooltipOpts: {
                content: "%s : Median Latency time at %x req/s was %y ms"
            },
            colors: ["#9ACD32", "#FF6347"]
        };
    },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesLatencyVsRequest"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotLatenciesVsRequest"), dataset, options);
        // setup overview
        $.plot($("#overviewLatenciesVsRequest"), dataset, prepareOverviewOptions(options));
    }
};

// Latencies vs Request
function refreshLatenciesVsRequest() {
        var infos = latenciesVsRequestInfos;
        prepareSeries(infos.data);
        if(isGraph($("#flotLatenciesVsRequest"))){
            infos.createGraph();
        }else{
            var choiceContainer = $("#choicesLatencyVsRequest");
            createLegend(choiceContainer, infos);
            infos.createGraph();
            setGraphZoomable("#flotLatenciesVsRequest", "#overviewLatenciesVsRequest");
            $('#footerLatenciesVsRequest .legendColorBox > div').each(function(i){
                $(this).clone().prependTo(choiceContainer.find("li").eq(i));
            });
        }
};

var hitsPerSecondInfos = {
        data: {"result": {"minY": 0.6, "minX": 1.72181274E12, "maxY": 1.3, "series": [{"data": [[1.72181304E12, 1.2166666666666666], [1.72181274E12, 1.1], [1.7218134E12, 1.3], [1.7218131E12, 1.2666666666666666], [1.72181328E12, 1.2333333333333334], [1.72181298E12, 1.2], [1.72181334E12, 1.2333333333333334], [1.72181352E12, 0.6], [1.72181322E12, 1.25], [1.72181292E12, 1.2333333333333334], [1.7218128E12, 1.2833333333333334], [1.72181346E12, 1.2333333333333334], [1.72181316E12, 1.25], [1.72181286E12, 1.2666666666666666]], "isOverall": false, "label": "hitsPerSecond", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.72181352E12, "title": "Hits Per Second"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of hits / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendHitsPerSecond"
                },
                selection: {
                    mode : 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y.2 hits/sec"
                }
            };
        },
        createGraph: function createGraph() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesHitsPerSecond"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotHitsPerSecond"), dataset, options);
            // setup overview
            $.plot($("#overviewHitsPerSecond"), dataset, prepareOverviewOptions(options));
        }
};

// Hits per second
function refreshHitsPerSecond(fixTimestamps) {
    var infos = hitsPerSecondInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 7200000);
    }
    if (isGraph($("#flotHitsPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesHitsPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotHitsPerSecond", "#overviewHitsPerSecond");
        $('#footerHitsPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var codesPerSecondInfos = {
        data: {"result": {"minY": 0.7666666666666667, "minX": 1.72181274E12, "maxY": 1.3, "series": [{"data": [[1.72181304E12, 1.2166666666666666], [1.72181274E12, 0.7666666666666667], [1.7218134E12, 1.3], [1.7218131E12, 1.2666666666666666], [1.72181328E12, 1.2333333333333334], [1.72181298E12, 1.2], [1.72181334E12, 1.2333333333333334], [1.72181352E12, 0.9333333333333333], [1.72181322E12, 1.25], [1.72181292E12, 1.2333333333333334], [1.7218128E12, 1.2833333333333334], [1.72181346E12, 1.2333333333333334], [1.72181316E12, 1.25], [1.72181286E12, 1.2666666666666666]], "isOverall": false, "label": "200", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.72181352E12, "title": "Codes Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of responses / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendCodesPerSecond"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "Number of Response Codes %s at %x was %y.2 responses / sec"
                }
            };
        },
    createGraph: function() {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesCodesPerSecond"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotCodesPerSecond"), dataset, options);
        // setup overview
        $.plot($("#overviewCodesPerSecond"), dataset, prepareOverviewOptions(options));
    }
};

// Codes per second
function refreshCodesPerSecond(fixTimestamps) {
    var infos = codesPerSecondInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 7200000);
    }
    if(isGraph($("#flotCodesPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesCodesPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotCodesPerSecond", "#overviewCodesPerSecond");
        $('#footerCodesPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var transactionsPerSecondInfos = {
        data: {"result": {"minY": 0.7666666666666667, "minX": 1.72181274E12, "maxY": 1.3, "series": [{"data": [[1.72181304E12, 1.2166666666666666], [1.72181274E12, 0.7666666666666667], [1.7218134E12, 1.3], [1.7218131E12, 1.2666666666666666], [1.72181328E12, 1.2333333333333334], [1.72181298E12, 1.2], [1.72181334E12, 1.2333333333333334], [1.72181352E12, 0.9333333333333333], [1.72181322E12, 1.25], [1.72181292E12, 1.2333333333333334], [1.7218128E12, 1.2833333333333334], [1.72181346E12, 1.2333333333333334], [1.72181316E12, 1.25], [1.72181286E12, 1.2666666666666666]], "isOverall": false, "label": "Insert Invoice-success", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.72181352E12, "title": "Transactions Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of transactions / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendTransactionsPerSecond"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y transactions / sec"
                }
            };
        },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesTransactionsPerSecond"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotTransactionsPerSecond"), dataset, options);
        // setup overview
        $.plot($("#overviewTransactionsPerSecond"), dataset, prepareOverviewOptions(options));
    }
};

// Transactions per second
function refreshTransactionsPerSecond(fixTimestamps) {
    var infos = transactionsPerSecondInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyTransactionsPerSecond");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 7200000);
    }
    if(isGraph($("#flotTransactionsPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTransactionsPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTransactionsPerSecond", "#overviewTransactionsPerSecond");
        $('#footerTransactionsPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var totalTPSInfos = {
        data: {"result": {"minY": 0.7666666666666667, "minX": 1.72181274E12, "maxY": 1.3, "series": [{"data": [[1.72181304E12, 1.2166666666666666], [1.72181274E12, 0.7666666666666667], [1.7218134E12, 1.3], [1.7218131E12, 1.2666666666666666], [1.72181328E12, 1.2333333333333334], [1.72181298E12, 1.2], [1.72181334E12, 1.2333333333333334], [1.72181352E12, 0.9333333333333333], [1.72181322E12, 1.25], [1.72181292E12, 1.2333333333333334], [1.7218128E12, 1.2833333333333334], [1.72181346E12, 1.2333333333333334], [1.72181316E12, 1.25], [1.72181286E12, 1.2666666666666666]], "isOverall": false, "label": "Transaction-success", "isController": false}, {"data": [], "isOverall": false, "label": "Transaction-failure", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.72181352E12, "title": "Total Transactions Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of transactions / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendTotalTPS"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y transactions / sec"
                },
                colors: ["#9ACD32", "#FF6347"]
            };
        },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesTotalTPS"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotTotalTPS"), dataset, options);
        // setup overview
        $.plot($("#overviewTotalTPS"), dataset, prepareOverviewOptions(options));
    }
};

// Total Transactions per second
function refreshTotalTPS(fixTimestamps) {
    var infos = totalTPSInfos;
    // We want to ignore seriesFilter
    prepareSeries(infos.data, false, true);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 7200000);
    }
    if(isGraph($("#flotTotalTPS"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTotalTPS");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTotalTPS", "#overviewTotalTPS");
        $('#footerTotalTPS .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

// Collapse the graph matching the specified DOM element depending the collapsed
// status
function collapse(elem, collapsed){
    if(collapsed){
        $(elem).parent().find(".fa-chevron-up").removeClass("fa-chevron-up").addClass("fa-chevron-down");
    } else {
        $(elem).parent().find(".fa-chevron-down").removeClass("fa-chevron-down").addClass("fa-chevron-up");
        if (elem.id == "bodyBytesThroughputOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshBytesThroughputOverTime(true);
            }
            document.location.href="#bytesThroughputOverTime";
        } else if (elem.id == "bodyLatenciesOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshLatenciesOverTime(true);
            }
            document.location.href="#latenciesOverTime";
        } else if (elem.id == "bodyCustomGraph") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshCustomGraph(true);
            }
            document.location.href="#responseCustomGraph";
        } else if (elem.id == "bodyConnectTimeOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshConnectTimeOverTime(true);
            }
            document.location.href="#connectTimeOverTime";
        } else if (elem.id == "bodyResponseTimePercentilesOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimePercentilesOverTime(true);
            }
            document.location.href="#responseTimePercentilesOverTime";
        } else if (elem.id == "bodyResponseTimeDistribution") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimeDistribution();
            }
            document.location.href="#responseTimeDistribution" ;
        } else if (elem.id == "bodySyntheticResponseTimeDistribution") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshSyntheticResponseTimeDistribution();
            }
            document.location.href="#syntheticResponseTimeDistribution" ;
        } else if (elem.id == "bodyActiveThreadsOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshActiveThreadsOverTime(true);
            }
            document.location.href="#activeThreadsOverTime";
        } else if (elem.id == "bodyTimeVsThreads") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTimeVsThreads();
            }
            document.location.href="#timeVsThreads" ;
        } else if (elem.id == "bodyCodesPerSecond") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshCodesPerSecond(true);
            }
            document.location.href="#codesPerSecond";
        } else if (elem.id == "bodyTransactionsPerSecond") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTransactionsPerSecond(true);
            }
            document.location.href="#transactionsPerSecond";
        } else if (elem.id == "bodyTotalTPS") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTotalTPS(true);
            }
            document.location.href="#totalTPS";
        } else if (elem.id == "bodyResponseTimeVsRequest") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimeVsRequest();
            }
            document.location.href="#responseTimeVsRequest";
        } else if (elem.id == "bodyLatenciesVsRequest") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshLatenciesVsRequest();
            }
            document.location.href="#latencyVsRequest";
        }
    }
}

/*
 * Activates or deactivates all series of the specified graph (represented by id parameter)
 * depending on checked argument.
 */
function toggleAll(id, checked){
    var placeholder = document.getElementById(id);

    var cases = $(placeholder).find(':checkbox');
    cases.prop('checked', checked);
    $(cases).parent().children().children().toggleClass("legend-disabled", !checked);

    var choiceContainer;
    if ( id == "choicesBytesThroughputOverTime"){
        choiceContainer = $("#choicesBytesThroughputOverTime");
        refreshBytesThroughputOverTime(false);
    } else if(id == "choicesResponseTimesOverTime"){
        choiceContainer = $("#choicesResponseTimesOverTime");
        refreshResponseTimeOverTime(false);
    }else if(id == "choicesResponseCustomGraph"){
        choiceContainer = $("#choicesResponseCustomGraph");
        refreshCustomGraph(false);
    } else if ( id == "choicesLatenciesOverTime"){
        choiceContainer = $("#choicesLatenciesOverTime");
        refreshLatenciesOverTime(false);
    } else if ( id == "choicesConnectTimeOverTime"){
        choiceContainer = $("#choicesConnectTimeOverTime");
        refreshConnectTimeOverTime(false);
    } else if ( id == "choicesResponseTimePercentilesOverTime"){
        choiceContainer = $("#choicesResponseTimePercentilesOverTime");
        refreshResponseTimePercentilesOverTime(false);
    } else if ( id == "choicesResponseTimePercentiles"){
        choiceContainer = $("#choicesResponseTimePercentiles");
        refreshResponseTimePercentiles();
    } else if(id == "choicesActiveThreadsOverTime"){
        choiceContainer = $("#choicesActiveThreadsOverTime");
        refreshActiveThreadsOverTime(false);
    } else if ( id == "choicesTimeVsThreads"){
        choiceContainer = $("#choicesTimeVsThreads");
        refreshTimeVsThreads();
    } else if ( id == "choicesSyntheticResponseTimeDistribution"){
        choiceContainer = $("#choicesSyntheticResponseTimeDistribution");
        refreshSyntheticResponseTimeDistribution();
    } else if ( id == "choicesResponseTimeDistribution"){
        choiceContainer = $("#choicesResponseTimeDistribution");
        refreshResponseTimeDistribution();
    } else if ( id == "choicesHitsPerSecond"){
        choiceContainer = $("#choicesHitsPerSecond");
        refreshHitsPerSecond(false);
    } else if(id == "choicesCodesPerSecond"){
        choiceContainer = $("#choicesCodesPerSecond");
        refreshCodesPerSecond(false);
    } else if ( id == "choicesTransactionsPerSecond"){
        choiceContainer = $("#choicesTransactionsPerSecond");
        refreshTransactionsPerSecond(false);
    } else if ( id == "choicesTotalTPS"){
        choiceContainer = $("#choicesTotalTPS");
        refreshTotalTPS(false);
    } else if ( id == "choicesResponseTimeVsRequest"){
        choiceContainer = $("#choicesResponseTimeVsRequest");
        refreshResponseTimeVsRequest();
    } else if ( id == "choicesLatencyVsRequest"){
        choiceContainer = $("#choicesLatencyVsRequest");
        refreshLatenciesVsRequest();
    }
    var color = checked ? "black" : "#818181";
    if(choiceContainer != null) {
        choiceContainer.find("label").each(function(){
            this.style.color = color;
        });
    }
}

