var config = require('./../config');
var _ = require('lodash');
var agreementType = require("../utils/orderAgreementType")
var utils = require("../utils/utils")
var errorMessage = require("../utils/errorMessage")

async function getAgreement(req, res) {

    var type = req.query.type

    if (_.isEmpty(type))
        throw Error(errorMessage.TYPE_REQUIRED)

    if (_.isEmpty(agreementType[type]))
        throw Error(errorMessage.INVALID_TYPE)

    var result = utils.generateAgreement(type, req.query, req.httpContext)

    return result
}


module.exports = {
    getAgreement,
}