var express = require('express');
var app = express();
var path = require("path")
var fileUpload = require("express-fileupload")
var router = require('./routers/router')
var bodyParser = require('body-parser');
var config = require('./config')
var db = require('./db')
var swaggerUi = require('swagger-ui-express');
var spec = require('./specs/swagger.json');
var uploads = path.join(__dirname, 'uploads')
var templates = path.join(__dirname, 'template')
var authMiddleware = require("./middleware/authMiddleware")
var errorHandler = require("./middleware/errorHandler")
var identityMiddleware = require('./middleware/identityMiddleware');

const winstonExpress = require('express-winston');
require('winston-mongodb');
const winston = require("winston");

main()

async function main() {
    await db.init()

    app.use(fileUpload())
    app.use(bodyParser.json({
        limit: '50mb'
    }))
    app.use(bodyParser.urlencoded({
        extended: false
    }));
    app.get('/docs', (req, res) => {
        res.send(spec);
    })
    app.use('/swagger/docs', swaggerUi.serve, swaggerUi.setup(spec));

    app.use('/uploads', express.static(uploads))
    app.use('/templates', express.static(templates))

    winstonExpress.requestWhitelist.push('body');
    winstonExpress.responseWhitelist.push('body');
    var logger = new winstonExpress.logger({
        transports: [
            new winston.transports.MongoDB({
                db: config.logging.uri,
                collection: config.logging.collection,
                level: "info",
                storeHost: true,
                capped: true,
                metaKey: 'meta'
            })
        ],
        requestWhitelist: ["body", "headers"],
        responseWhitelist: ["body", "headers"],
        meta: true, // optional: control whether you want to log the meta data about the request (default to true)
        ignoredRoutes: ["/alive/checkStatus"] // optional: allows to skip some log messages based on request and/or response

    });
    app.use(logger);
    app.use(authMiddleware)
    app.use(identityMiddleware())
    app.use("/api", router);
    app.use(errorHandler())

    console.log("Cedit service API run on localhost:" + config.port || "8080")

    app.listen(config.port || 8080);
}
