var _ = require("lodash")
var db = require("../db")
var Client = require("../domain/client");
var {
    insertOne,
    updateOne,
    patchOne
} = require("./mongoHelper");

async function getClient(id, secret) {
    var collection = db.instance().collection('client')

    var result = await collection.findOne({ clientId: id, clientSecret: secret, isActive: true })
    if (result)
        return new Client(result)
    else
        throw Error('Invalid Client')
}

async function updateClientConfig(config, context) {
    var collection = db.instance().collection('client')

    var whereQuery = {
        clientId: context.client.clientId
    }

    if (_.isEmpty(config)) {
        throw Error("Must at least update 1 field")
    }

    var configPatch = context.client.config

    if (!_.isEmpty(config.fxEmailBaseUrl)) {
        configPatch.fxEmailBaseUrl = config.fxEmailBaseUrl
    }

    if (!_.isEmpty(config.fxEmailClientId)) {
        configPatch.fxEmailClientId = config.fxEmailClientId
    }

    if (!_.isEmpty(config.fxEmailClientSecret)) {
        configPatch.fxEmailClientSecret = config.fxEmailClientSecret
    }

    if (!_.isEmpty(config.buyerAgreement)) {
        configPatch.buyerAgreement = config.buyerAgreement
    }

    if (!_.isEmpty(config.sellerAgreement)) {
        configPatch.sellerAgreement = config.sellerAgreement
    }

    if (!_.isEmpty(config.employeeEmail)) {
        configPatch.employeeEmail = config.employeeEmail
    }

    if (config.processingCharge !== null && config.processingCharge !== undefined) {
        configPatch.processingCharge = config.processingCharge
    }

    if (config.monthlyCharge !== null && config.monthlyCharge !== undefined) {
        configPatch.monthlyCharge = config.monthlyCharge
    }

    if (config.overdueCharge !== null && config.overdueCharge !== undefined) {
        configPatch.overdueCharge = config.overdueCharge
    }

    if (config.gracePeriod !== null && config.gracePeriod !== undefined) {
        configPatch.gracePeriod = parseInt(config.gracePeriod, 10)
    }

    if (config.monthlyChargeCount !== null && config.monthlyChargeCount !== undefined) {
        configPatch.monthlyChargeCount = parseInt(config.monthlyChargeCount, 10)
    }

    if (config.creditPeriod !== null && config.creditPeriod !== undefined) {
        configPatch.creditPeriod = parseInt(config.creditPeriod, 10)
    }

    if (config.overduePeriod !== null && config.overduePeriod !== undefined) {
        configPatch.overduePeriod = parseInt(config.overduePeriod, 10)
    }

    var {
        acknowledged,
        matchedCount,
        modifiedCount
    } = await patchOne(collection, whereQuery, { config: configPatch }, context)

    if (matchedCount !== 1)
        throw Error('No record found')
    return
}

module.exports = {
    getClient,
    updateClientConfig,
}