var {
    insertOne,
    updateOne,
    patchOne
} = require("./mongoHelper");
var db = require("../db")
var _ = require('lodash');

var ObjectId = require("mongodb").ObjectID;
var CreditUser = require("../domain/creditUser");

var userStatus = require("../utils/creditUserStatus")

var sortDir = require("../utils/sortDir")
var sortOption = require("../utils/creditUserField");


async function getAllUsers(
    limit,
    offset,
    sort,
    sortBy,
    status,
    customerIds,
    customerId,
    toCreditLimit,
    fromCreditLimit,
    toCreditUsed,
    fromCreditUsed,
    toTotalCreditUsed,
    fromTotalCreditUsed,
    toCreatedDate,
    fromCreatedDate,
    toTotalContra,
    fromTotalContra,
    context,
) {
    var collection = db.instance().collection('creditUser')

    var sortQuery = {};
    sortQuery[sortOption[sortBy] || '_id'] = sortDir[sort] || 1

    var whereQuery = []
    whereQuery.push({ clientId: context.client.id })
    if (!_.isEmpty(userStatus[status])) {
        whereQuery.push({ 'status': userStatus[status] })
    }
    if (!_.isEmpty(customerId)) {
        whereQuery.push({ 'customerId': customerId })
    }
    else if (!_.isEmpty(customerIds)) {
        var customerIdArray = JSON.parse(customerIds)
        whereQuery.push({ 'customerId': { $in: customerIdArray } })
    }
    if (!isNaN(toCreditLimit)) {
        whereQuery.push({ 'creditLimit': { $lte: toCreditLimit } })
    }
    if (!isNaN(fromCreditLimit)) {
        whereQuery.push({ 'creditLimit': { $gte: fromCreditLimit } })
    }
    if (!isNaN(toCreditUsed)) {
        whereQuery.push({ 'creditUsed': { $lte: toCreditUsed } })
    }
    if (!isNaN(fromCreditUsed)) {
        whereQuery.push({ 'creditUsed': { $gte: fromCreditUsed } })
    }
    if (!isNaN(toTotalCreditUsed)) {
        whereQuery.push({ 'totalCreditUsed': { $lte: toTotalCreditUsed } })
    }
    if (!isNaN(fromTotalCreditUsed)) {
        whereQuery.push({ 'totalCreditUsed': { $gte: fromTotalCreditUsed } })
    }
    if (!_.isEmpty(toCreatedDate)) {
        whereQuery.push({ 'createdDatetime': { $lte: new Date(toCreatedDate) } })
    }
    if (!_.isEmpty(fromCreatedDate)) {
        whereQuery.push({ 'createdDatetime': { $gte: new Date(fromCreatedDate) } })
    }
    if (!isNaN(toTotalContra)) {
        whereQuery.push({ 'totalContra': { $lte: toTotalContra } })
    }
    if (!isNaN(fromTotalContra)) {
        whereQuery.push({ 'totalContra': { $gte: fromTotalContra } })
    }
    var result = await collection
        .find(whereQuery.length === 0 ? {} : { $and: whereQuery })
        .skip(offset)
        .limit(limit)
        .sort(sortQuery)
        .collation({ locale: "en_US", numericOrdering: true })
        .toArray();

    return result.map(c => new CreditUser(c));
}

async function getUsersCount(
    status,
    customerIds,
    customerId,
    toCreditLimit,
    fromCreditLimit,
    toCreditUsed,
    fromCreditUsed,
    toTotalCreditUsed,
    fromTotalCreditUsed,
    toCreatedDate,
    fromCreatedDate,
    toTotalContra,
    fromTotalContra,
    context,
) {
    var collection = db.instance().collection('creditUser')

    var whereQuery = []
    whereQuery.push({ clientId: context.client.id })
    if (!_.isEmpty(userStatus[status])) {
        whereQuery.push({ 'status': userStatus[status] })
    }
    if (!_.isEmpty(customerId)) {
        whereQuery.push({ 'customerId': customerId })
    }
    else if (!_.isEmpty(customerIds)) {
        var customerIdArray = JSON.parse(customerIds)
        whereQuery.push({ 'customerId': { $in: customerIdArray } })
    }
    if (!isNaN(toCreditLimit)) {
        whereQuery.push({ 'creditLimit': { $lte: toCreditLimit } })
    }
    if (!isNaN(fromCreditLimit)) {
        whereQuery.push({ 'creditLimit': { $gte: fromCreditLimit } })
    }
    if (!isNaN(toCreditUsed)) {
        whereQuery.push({ 'creditUsed': { $lte: toCreditUsed } })
    }
    if (!isNaN(fromCreditUsed)) {
        whereQuery.push({ 'creditUsed': { $gte: fromCreditUsed } })
    }
    if (!isNaN(toTotalCreditUsed)) {
        whereQuery.push({ 'totalCreditUsed': { $lte: toTotalCreditUsed } })
    }
    if (!isNaN(fromTotalCreditUsed)) {
        whereQuery.push({ 'totalCreditUsed': { $gte: fromTotalCreditUsed } })
    }
    if (!_.isEmpty(toCreatedDate)) {
        whereQuery.push({ 'createdDatetime': { $lte: new Date(toCreatedDate) } })
    }
    if (!_.isEmpty(fromCreatedDate)) {
        whereQuery.push({ 'createdDatetime': { $gte: new Date(fromCreatedDate) } })
    }
    if (!isNaN(toTotalContra)) {
        whereQuery.push({ 'totalContra': { $lte: toTotalContra } })
    }
    if (!isNaN(fromTotalContra)) {
        whereQuery.push({ 'totalContra': { $gte: fromTotalContra } })
    }
    var result = await collection
        .count(whereQuery.length === 0 ? {} : { $and: whereQuery })

    return result
}

async function getUser(id, context) {
    var collection = db.instance().collection('creditUser')

    var whereQuery = { customerId: id, clientId: context.client.id }

    var result = await collection.findOne(whereQuery);
    if (result)
        return new CreditUser(result)
    else
        throw Error('Credit user not found')
}


async function isUserExist(id, context) {
    var collection = db.instance().collection('creditUser')

    var whereQuery = { customerId: id, clientId: context.client.id }

    var result = await collection.findOne(whereQuery);
    if (result)
        return true
    else
        return false
}

async function createUser(creditUser, context) {
    var collection = db.instance().collection('creditUser')

    delete creditUser.id;

    var result = await insertOne(collection, creditUser, context);
    var generatedData = customResultDatabase(result);
    return new CreditUser(generatedData);
}

async function updateUser(id, creditUser, context) {
    var collection = db.instance().collection('creditUser')

    var whereQuery = { customerId: id, clientId: context.client.id }

    if (_.isEmpty(creditUser)) {
        throw Error('Must at least update 1 field')
    }
    var creditUserPatch = {};
    if (!_.isEmpty(creditUser.customerId)) {
        creditUserPatch.customerId = creditUser.customerId;
    }
    if (!_.isEmpty(creditUser.status)) {
        creditUserPatch.status = creditUser.status;
    }
    if (creditUser.creditLimit !== null && creditUser.creditLimit !== undefined) {
        creditUserPatch.creditLimit = creditUser.creditLimit
    }
    if (creditUser.creditUsed !== null && creditUser.creditUsed !== undefined) {
        creditUserPatch.creditUsed = creditUser.creditUsed
    }
    if (creditUser.totalCreditUsed !== null && creditUser.totalCreditUsed !== undefined) {
        creditUserPatch.totalCreditUsed = creditUser.totalCreditUsed
    }
    if (creditUser.totalContra !== null && creditUser.totalContra !== undefined) {
        creditUserPatch.totalContra = creditUser.totalContra
    }
    if (!_.isEmpty(creditUser.remarks)) {
        creditUserPatch.remarks = creditUser.remarks
    }

    if (!_.isEmpty(creditUser.creditOrderReference))
        creditUserPatch.creditOrderReference = creditUser.creditOrderReference

    var {
        acknowledged,
        matchedCount,
        modifiedCount
    } = await patchOne(collection, whereQuery, creditUserPatch, context)

    if (matchedCount !== 1)
        throw Error('No record found')
    return
}

function customResultDatabase(result) {
    if (result && result.ops && result.ops.length == 1) {
        generatedResult = result.ops[0];
        return generatedResult;
    } else {
        return result.ops;
    }

}

module.exports = {
    getAllUsers,
    getUser,
    isUserExist,
    createUser,
    updateUser,
    getUsersCount,
}