var db = require("../db")
var _ = require('lodash');

var ObjectId = require("mongodb").ObjectID;
var EventLog = require("../domain/eventLog");

var acionType = require("../utils/eventLogActionType")
var logType = require("../utils/eventLogType")

var sortDir = require("../utils/sortDir")
var sortOption = require("../utils/eventLogField");

async function getAllLogs(
    limit,
    offset,
    sort,
    sortBy,
    action,
    actions,
    type,
    types,
    refId,
    context,
) {
    var collection = db.instance().collection('eventLog')

    var sortQuery = {};
    sortQuery[sortOption[sortBy] || '_id'] = sortDir[sort] || 1

    var whereQuery = []
    whereQuery.push({ clientId: context.client.id })
    if (!_.isEmpty(acionType[action])) {
        whereQuery.push({ 'action': actionType[action] })
    }
    else if (!_.isEmpty(actions)) {
        var actionArray = actions.filter(e => !_.isEmpty(actionType[e]))
        whereQuery.push({ 'action': { $in: actionArray } })
    }
    if (!_.isEmpty(logType[type])) {
        whereQuery.push({ 'type': logType[type] })
    }
    else if (!_.isEmpty(types)) {
        var typeArray = types.filter(e => !_.isEmpty(logType[e]))
        whereQuery.push({ 'type': { $in: typeArray } })
    }
    if (!_.isEmpty(refId)) {
        whereQuery.push({ 'refId': refId })
    }

    var result = await collection
        .find(whereQuery.length === 0 ? {} : { $and: whereQuery })
        .skip(offset)
        .limit(limit)
        .sort(sortQuery)
        .toArray();

    return result.map(c => new EventLog(c));
}

async function getLogCount(
    action,
    actions,
    type,
    types,
    refId,
    context,
) {
    var collection = db.instance().collection('eventLog')

    var whereQuery = []
    whereQuery.push({ clientId: context.client.id })
    if (!_.isEmpty(acionType[action])) {
        whereQuery.push({ 'action': actionType[action] })
    }
    else if (!_.isEmpty(actions)) {
        var actionArray = actions.filter(e => !_.isEmpty(actionType[e]))
        whereQuery.push({ 'action': { $in: actionArray } })
    }
    if (!_.isEmpty(logType[type])) {
        whereQuery.push({ 'type': logType[type] })
    }
    else if (!_.isEmpty(types)) {
        var typeArray = types.filter(e => !_.isEmpty(logType[e]))
        whereQuery.push({ 'type': { $in: typeArray } })
    }
    if (!_.isEmpty(refId)) {
        whereQuery.push({ 'refId': refId })
    }

    var result = await collection
        .count(whereQuery.length === 0 ? {} : { $and: whereQuery })

    return result
}

async function getLog(id) {
    var collection = db.instance().collection('eventLog')

    var result = await collection.findOne({ "_id": new ObjectId(id) });
    if (result)
        return new EventLog(result)
    else
        throw Error('Event log not found')
}

async function createLog(eventLog, context) {
    var collection = db.instance().collection('eventLog')

    delete eventLog.id
    eventLog.clientId = context.client.id

    await collection.insertOne(eventLog)
}

module.exports = {
    getAllLogs,
    getLog,
    createLog,
    getLogCount,
}