var express = require('express');
var asyncHandler = require('express-async-handler')
var router = express.Router();
var clientController = require("./../controller/clientController")


router.get('/configs', asyncHandler(async function (req, res) {
    var result = await clientController.getClientConfig(req, res)
    return res.status(200).send(result)
}))

router.patch('/configs', asyncHandler(async function (req, res) {
    await clientController.updateClientConfig(req, res)
    return res.status(200).send({ message: 'success' })
}))

router.get('/configs/agreementTemplate', asyncHandler(async function (req, res) {
    var result = await clientController.getAgreementTemplate(req, res)
    return res.status(200).send(result)
}))

router.post('/configs/agreementTemplate', asyncHandler(async function (req, res) {
    await clientController.uploadAgreementTemplate(req, res)
    return res.status(200).send({ message: 'success' })
}))

module.exports = router