var express = require('express');
var asyncHandler = require('express-async-handler')
var router = express.Router();
var creditOrderController = require('./../controller/creditOrderController')


router.get('/orders', asyncHandler(async function (req, res) {
    var result = await creditOrderController.getCreditOrderList(req, res);
    return res.status(200).send(result);
}))

router.post('/orders', asyncHandler(async function (req, res) {
    var result = await creditOrderController.createCreditOrder(req, res);
    return res.status(200).send(result);
}))

router.get('/orders/count', asyncHandler(async function (req, res) {
    var result = await creditOrderController.getOrdersCount(req, res)
    return res.status(200).send(result)
}))

router.get('/orders/:orderId', asyncHandler(async function (req, res) {
    var result = await creditOrderController.getCreditOrder(req, res);
    return res.status(200).send(result)
}))

router.patch('/orders/:orderId', asyncHandler(async function (req, res) {
    await creditOrderController.updateCreditOrder(req, res);
    return res.status(200).send({ message: 'success' })
}))

router.patch('/orders/:orderId/invoiceAmount', asyncHandler(async function (req, res) {
    await creditOrderController.updateInvoiceAmount(req, res)
    return res.status(200).send({ message: 'success' })
}))

router.post('/orders/:orderId/invoices', asyncHandler(async function (req, res) {
    if (req.files != undefined)
        await creditOrderController.uploadInvoice(req, res);
    else
        await creditOrderController.uploadInvoiceBase64(req, res)

    return res.status(200).send({ message: 'success' })
}))

router.delete('/orders/:orderId/invoices', asyncHandler(async function (req, res) {
    await creditOrderController.deleteInvoice(req, res);
    return res.status(200).send({ message: 'success' })
}))

router.post('/orders/:orderId/deliveryOrders', asyncHandler(async function (req, res) {
    await creditOrderController.uploadDeliveryOrder(req, res)
    return res.status(200).send({ message: 'success' })
}))

router.patch('/orders/:orderId/deliveryOrders/:deliveryOrderId', asyncHandler(async function (req, res) {
    await creditOrderController.updateDeliveryOrder(req, res)
    return res.status(200).send({ message: 'success' })
}))

router.delete('/orders/:orderId/deliveryOrders/:deliveryOrderId', asyncHandler(async function (req, res) {
    await creditOrderController.deleteDeliveryOrder(req, res)
    return res.status(200).send({ message: 'success' })
}))

router.post('/orders/:orderId/sellers/agreements', asyncHandler(async function (req, res) {
    await creditOrderController.saveSellerAgreement(req, res);
    return res.status(200).send({ message: 'success' })
}))

router.get('/orders/:orderId/history', asyncHandler(async function (req, res) {
    var result = await creditOrderController.getOrderHistory(req, res)
    return res.status(200).send(result)
}))

router.get('/deliveryOrders', asyncHandler(async function (req, res) {
    var result = await creditOrderController.getDeliveryOrders(req, res)
    return res.status(200).send(result)
}))

module.exports = router