var express = require('express');
var asyncHandler = require('express-async-handler')
var router = express.Router();
var transactionController = require('./../controller/creditOrderTransactionController')


router.get('/transactions', asyncHandler(async function (req, res) {
    var result = await transactionController.getTransactionList(req, res);
    return res.status(200).send(result);
}))

router.post('/transactions', asyncHandler(async function (req, res) {
    var result = await transactionController.createTransaction(req, res);
    return res.status(200).send(result);
}))

router.get('/transactions/:transactionId', asyncHandler(async function (req, res) {
    var result = await transactionController.getTransaction(req, res);
    return res.status(200).send(result)
}))

module.exports = router