var express = require('express');
var asyncHandler = require('express-async-handler')
var router = express.Router();
var creditPaymentController = require('./../controller/creditPaymentController')

router.get('/payments', asyncHandler(async function (req, res) {
    var result = await creditPaymentController.getPaymentList(req, res);
    return res.status(200).send(result);
}))

router.post('/payments', asyncHandler(async function (req, res) {
    var result = await creditPaymentController.createPayment(req, res);
    return res.status(200).send(result);
}))

router.get('/payments/:paymentId', asyncHandler(async function (req, res) {
    var result = await creditPaymentController.getPayment(req, res);
    return res.status(200).send(result)
}))

router.patch('/payments/:paymentId', asyncHandler(async function (req, res) {
    await creditPaymentController.updatePayment(req, res);
    return res.status(200).send({ message: 'success' })
}))

router.delete('/payments/:paymentId', asyncHandler(async function (req, res) {
    await creditPaymentController.deletePayment(req, res)
    return res.status(200).send({ message: 'success' })
}))

router.post('/payments/:paymentId/receipts', asyncHandler(async function (req, res) {
    if (req.files != undefined)
        await creditPaymentController.uploadReceipt(req, res);
    else
        await creditPaymentController.uploadReceiptBase64(req, res)
    return res.status(200).send({ message: 'success' })
}))

router.delete('/payments/:paymentId/receipts', asyncHandler(async function (req, res) {
    await creditPaymentController.deleteReceipt(req, res);
    return res.status(200).send({ message: 'success' })
}))

router.get('/payments/:paymentId/history', asyncHandler(async function (req, res) {
    var result = await creditPaymentController.getPaymentHistory(req, res)
    return res.status(200).send(result)
}))

module.exports = router