var express = require('express');
var asyncHandler = require('express-async-handler')
var router = express.Router();
var creditUserController = require('./../controller/creditUserController')


router.get('/users', asyncHandler(async function (req, res) {
    var result = await creditUserController.getUserList(req, res);
    return res.status(200).send(result);
}))

router.post('/users', asyncHandler(async function (req, res) {
    var result = await creditUserController.createUser(req, res);
    return res.status(200).send(result);
}))

router.get('/users/:customerId', asyncHandler(async function (req, res) {
    var result = await creditUserController.getUser(req, res);
    return res.status(200).send(result)
}))

router.patch('/users/:customerId', asyncHandler(async function (req, res) {
    await creditUserController.updateUser(req, res);
    return res.status(200).send({ message: 'success' })
}))

router.get('/users/:customerId/history', asyncHandler(async function (req, res) {
    var result = await creditUserController.getUserHistory(req, res)
    return res.status(200).send(result)
}))


module.exports = router