var express = require('express');
var asyncHandler = require('express-async-handler')
var router = express.Router();
var orderStatus = require("../utils/creditOrderStatus")
var creditOrderController = require("../controller/creditOrderController")

router.get('/lookup/orderStatus', asyncHandler(async function (req, res) {
    return res.status(200).send(Object.keys(orderStatus))
}))

router.post('/calculate', asyncHandler(async function (req, res) {
    var result = await creditOrderController.calculateInvoiceAmount(req, res)
    return res.status(200).send(result)
}))

module.exports = router