var express = require('express')
var router = express.Router()
var healthRouter = require('./healthRouter')
var creditUserRouter = require('./creditUserRouter')
var creditOrderRouter = require('./creditOrderRouter')
var creditOrderTransactionRouter = require('./creditOrderTransactionRouter')
var creditPaymentRouter = require('./creditPaymentRouter')
var orderAgreementRouter = require("./orderAgreementRouter")
var lookupRouter = require("./lookupRouter")
var clientRouter = require("./clientRouter")
var asyncHandler = require("express-async-handler")
var db = require("../db")

router.use((req, res, next) => {
    console.log("Called: ", req.method, req.path)
    next();
})

router.use(healthRouter);
router.use("/credit", creditUserRouter);
router.use("/credit", creditOrderRouter)
router.use("/credit", creditOrderTransactionRouter)
router.use("/credit", creditPaymentRouter)
router.use("/credit", orderAgreementRouter)
router.use("/credit", lookupRouter)
router.use("/credit", clientRouter)

router.post('/credit/restartDb', asyncHandler(async function (req, res) {
    await db.manualInit()
    return res.status(200).send({ message: 'success' });
}))

router.use("*", (req, res) => {
    return res.status(404).send({ message: 'Cannot ' + req.method + ' ' + req.originalUrl })
})


module.exports = router