var axios = require('axios')
var fs = require('fs')
var handlebars = require("handlebars")
var errorMessage = require("../utils/errorMessage")

async function sendDeliveryOrderEmail(
    customerId,
    orderId,
    customerName,
    sellerName,
    orderUrl,
    context,
) {
    var templateHtml = fs.readFileSync("template/deliveryOrderEmailTemplate.html", "utf8")

    var template = handlebars.compile(templateHtml)
    var finalHtml = template({
        customer_name: customerName,
        seller_name: sellerName,
        id_order: orderId,
        order_url: orderUrl,
    })

    var api = axios.create({
        baseURL: context.client.config.fxEmailBaseUrl,
        auth: {
            username: context.client.config.fxEmailClientId,
            password: context.client.config.fxEmailClientSecret,
        }
    })

    await api.post(
        '/send',
        {
            subject: "Delivery Order for Order " + orderId,
            id_customer: customerId,
            content: finalHtml
        }
    ).catch(function (error) {
        throw Error(errorMessage.FX_EMAIL_ERROR + '=> ' + error)
    })

    return
}

async function sendPaymentUploadedEmail(
    buyerName,
    amount,
    referenceNumber,
    receiptUrl,
    context,
) {
    var templateHtml = fs.readFileSync("template/paymentUploadedTemplate.html", "utf8")

    var template = handlebars.compile(templateHtml)
    var finalHtml = template({
        buyer_name: buyerName || 'A buyer',
        amount: amount,
        reference_number: referenceNumber,
        receipt_url: receiptUrl,
    })

    var api = axios.create({
        baseURL: context.client.config.fxEmailBaseUrl,
        auth: {
            username: context.client.config.fxEmailClientId,
            password: context.client.config.fxEmailClientSecret,
        }
    })

    await api.post(
        '/send',
        {
            subject: "Payment Slip Uploaded",
            email: context.client.config.employeeEmail,
            content: finalHtml
        }
    ).catch(function (error) {
        throw Error(errorMessage.FX_EMAIL_ERROR + '=> ' + error)
    })

    return
}

async function sendPaymentUpdatedEmail(
    customerId,
    status,
    amount,
    referenceNumber,
    remark,
    receiptUrl,
    context,
) {
    var templateHtml = fs.readFileSync("template/paymentUpdatedTemplate.html", "utf8")

    var template = handlebars.compile(templateHtml)
    var finalHtml = template({
        status: status,
        amount: amount,
        reference_number: referenceNumber,
        remark: remark || '-',
        receipt_url: receiptUrl,
    })

    var api = axios.create({
        baseURL: context.client.config.fxEmailBaseUrl,
        auth: {
            username: context.client.config.fxEmailClientId,
            password: context.client.config.fxEmailClientSecret,
        }
    })

    await api.post(
        '/send',
        {
            subject: "Payment Slip " + status,
            id_customer: customerId,
            content: finalHtml
        }
    ).catch(function (error) {
        throw Error(errorMessage.FX_EMAIL_ERROR + '=> ' + error)
    })

    return
}

module.exports = {
    sendDeliveryOrderEmail,
    sendPaymentUpdatedEmail,
    sendPaymentUploadedEmail,
}