const GeneralResponse = require('./../model/general/generalResponse');
var fs = require("fs")
var path = require("path")
var handlebars = require("handlebars")
var _ = require("lodash")
var agreementType = require("./orderAgreementType")
const {
    MongoClient,
    ObjectID
} = require("mongodb");
const config = require("../config");
var eventLogRepository = require("../repository/eventLogRepository")
var EventLog = require("../domain/eventLog");

function generateGeneralStatusList(response, statusCode) {
    return response.GeneralResponse({
        "statusCode": statusCode
    })
}

async function connectDb() {
    const client = await MongoClient.connect(config.mongoDb.uri, {
            useNewUrlParser: true
        }),
        database = client.db(config.mongoDb.database);

    return [client, database]
}

async function generateAgreement(type, variables, context) {

    var {
        buyerName,
        buyerAddress,
        buyerPhone,
        sellerName,
        sellerShopName,
        sellerAddress,
        orderReference,
        orderPlacedTimestamp,
        orderApprovedTimestamp,
        orderPlacedDate,
        sellerAgreementDate,
        eulaAgreementDate,
        uniqueShopName,
    } = variables

    var templateHtml
    var dataBinding = {
        buyerName: buyerName || '-',
        buyerAddress: buyerAddress || '-',
        buyerPhone: buyerPhone || '-',
        sellerName: sellerName || '-',
        sellerShopName: sellerShopName || '-',
        sellerAddress: sellerAddress || '-',
        orderReference: orderReference || '-',
        orderPlacedTimestamp: orderPlacedTimestamp || '-',
        orderApprovedTimestamp: orderApprovedTimestamp || '-',
        orderPlacedDate: orderPlacedDate || '-',
        sellerAgreementDate: sellerAgreementDate || '-',
        eulaAgreementDate: eulaAgreementDate || '-',
        uniqueShopName: uniqueShopName || '-',
    }

    switch (type) {
        case agreementType.BUYER:
            var buyerAgreementUrl = context.client.config.buyerAgreement
            if (!_.isEmpty(buyerAgreementUrl)) {
                var filename = buyerAgreementUrl.substring(buyerAgreementUrl.lastIndexOf('/') + 1)
                var filePath = "uploads/templates/" + filename

                if (fs.existsSync(filePath)) {
                    templateHtml = fs.readFileSync(filePath, "utf8")
                } else {
                    templateHtml = fs.readFileSync("template/buyerAgreement.html", "utf8")
                }
            } else {
                templateHtml = fs.readFileSync("template/buyerAgreement.html", "utf8")
            }

            break;
        case agreementType.SELLER:
            var sellerAgreementUrl = context.client.config.sellerAgreement
            if (!_.isEmpty(sellerAgreementUrl)) {
                var filename = sellerAgreementUrl.substring(sellerAgreementUrl.lastIndexOf('/') + 1)
                var filePath = "uploads/templates/" + filename

                if (fs.existsSync(filePath)) {
                    templateHtml = fs.readFileSync(filePath, "utf8")
                } else {
                    templateHtml = fs.readFileSync("template/sellerAgreement.html", "utf8")
                }
            } else {
                templateHtml = fs.readFileSync("template/sellerAgreement.html", "utf8")
            }
            default:
                break;
    }

    var template = handlebars.compile(templateHtml)
    var finalHtml = template(dataBinding)

    return finalHtml
}

function ensureDirectoryExistence(filePath) {
    var dirname = path.dirname(filePath)
    if (fs.existsSync(dirname))
        return true
    ensureDirectoryExistence(dirname)
    fs.mkdirSync(dirname)
}

function decodeJwt(token) {
    if (_.isEmpty(token)) return

    var base64String = token.split('.')[1]
    var decodedValue = JSON.parse(Buffer.from(base64String, 'base64').toString('ascii'))
    return decodedValue
}

async function logEvent(req, action, type, oldData, newData, refId) {
    var {
        oldData,
        newData
    } = cleanLogData(oldData, newData, action === 'DELETE')

    var raw = {
        timestamp: new Date(),
        action: action,
        type,
        oldData: oldData,
        newData: newData,
        actor: req.httpContext.identity,
        refId: refId,
    }

    var eventLog = new EventLog(raw)

    await eventLogRepository.createLog(eventLog, req.httpContext, )
}

function clone(object) {
    return JSON.parse(JSON.stringify(object))
}

// remove properties with null/undefined values
function clean(object) {
    for (var propName in object) {
        if (object[propName] === null || object[propName] === undefined) {
            delete object[propName]
        }
    }
    return object
}

// remove properties that has non-matching keys
function retain(object, keys) {
    for (var propName in object) {
        if (!keys.includes(propName)) {
            delete object[propName]
        }
    }
    return object
}

function cleanLogData(oldData, newData, isDeleting = false) {

    if (!isDeleting) {
        newData = clean(newData)
    }

    if (oldData && newData) {
        oldData = retain(oldData, Object.keys(newData))
    }

    return {
        oldData,
        newData
    }
}

function isValidNumber(object) {
    return object !== null && object !== undefined && typeof object == "number"
}

module.exports = {
    generateGeneralStatusList,
    connectDb,
    generateAgreement,
    ensureDirectoryExistence,
    decodeJwt,
    logEvent,
    clone,
    isValidNumber,
}